# Drop Summary Extension

![drop summary](drop-summary.gif)

This VS Code extension generates AI-powered summaries for your content using a custom model. It's designed to streamline the process of creating summaries directly within your editor.

## Features

- Generate summaries with a single command
- Stream responses from the AI model in real-time
- Customizable API endpoint and model selection
- Inserts summaries directly into your active document

## Requirements

- VS Codium 1.90.0 or higher
- An active network connection to reach the API endpoint

## Installation

1. Open VS Codium
2. Open the command palette
3. Find "install from VSIX"
4. Navigate to the `.vsix` file
5. Install it

## Building The Model

```bash
$ ollama create drop-summary -f Modelfile
```

## Usage

1. Open a document you want to summarize
2. Run the command "Drop Summary" (Ctrl+Shift+P, then type/find "Drop Summary")
3. Wait for the summary to be generated and inserted into your document

## Extension Settings

This extension contributes the following settings:

* `Drop Summary.apiUrl`: The URL of the API endpoint (default: "http://127.0.0.1:11434/api/generate")
* `Drop Summary.model`: The name of the model to use (default: "drop-summary")

## Known Issues

- The extension currently doesn't handle rate limiting or large document sizes. Use with caution on very large files.
- The model is likely to hallucinate if there's some interspersed/wonky HTML in the Markdown.

## Release Notes

### 0.0.2

Initial release of Drop Summary Extension.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

This extension is licensed under the [MIT License](LICENSE).
